/*
 * Decompiled with CFR 0.152.
 */
package com.vistara.sdk.dto.incident.attachment;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.vistara.sdk.dto.incident.attachment.Attachment;
import com.vistara.sdk.dto.incident.attachment.RandomString;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public class FileDeserializer
extends StdDeserializer<File> {
    private static final String javaTempPath = System.getProperty("java.io.tmpdir") + "/vistara";
    private static final String tempName = "temp.tmp";

    public FileDeserializer() {
        super(Attachment.class);
    }

    public FileDeserializer(Class<File> fileClass) {
        super(fileClass);
    }

    public File deserialize(JsonParser jp, DeserializationContext dctxt) throws IOException, JsonProcessingException {
        byte[] data = jp.getBinaryValue();
        File file = FileDeserializer.saveFileInTemp(data, tempName);
        return file;
    }

    private static File saveFileInTemp(byte[] data, String fileName) throws IOException {
        String tempPath;
        File tempFile;
        if (data == null || data.length <= 0) {
            return null;
        }
        if (fileName == null || fileName.isEmpty()) {
            fileName = RandomString.getNext();
        }
        if (!(tempFile = new File(javaTempPath, tempPath = RandomString.getNext() + "/" + fileName)).getParentFile().exists()) {
            tempFile.getParentFile().mkdirs();
        }
        FileOutputStream fileOuputStream = new FileOutputStream(tempFile);
        fileOuputStream.write(data);
        fileOuputStream.close();
        return tempFile;
    }
}

